<?php
/* 
The responsive table has a link in the header to order the column. The page is called 
again with a sort-variable in the URL. The function retrieves the variable from the 
URL and builds a new sorted objectlist. The current sort status and the appropriate 
Font Awesome arrow icon are added to the objectlist to build a proper table. 
*/

/**
 * @version     6.0.0
 * @package     mod_lsfields_600
 * @copyright   Copyright (C) 2026. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ampère Voltáge <> - https://www.longlane.nl
 */

namespace Joomla\Module\Lsfields\Site\Helper;

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Helper\ModuleHelper;

class LsfieldsHelper
{
	// grab the fields from the fieldsgroup	
	static public function getFields($fieldsgroup)
	{
	$db = Factory::getDbo();
	$query = $db
		->getQuery(true)
		->select($db->quoteName(['id', 'title']))
		->from($db->quoteName('#__fields'))
		->where($db->quoteName('group_id') . ' = ' . $fieldsgroup)
		->where($db->quoteName('state') . ' = ' . 1);
	$db->setQuery($query);
	$fields_id = $db->loadObjectList();
	return $fields_id;
	}	
	
	// grab the fieldvalues from the fieldsgroup	
	static public function getValues($field_id, $usergroup)
	{
	$db = Factory::getDbo();
	$query = $db
		->getQuery(true)
		->select($db->quoteName(['a.field_id', 'a.item_id', 'a.value', 'b.title', 'c.group_id']))
		->from($db->quoteName('#__fields_values', 'a'))
	    ->join('INNER', $db->quoteName('#__fields', 'b') . ' ON (' . $db->quoteName('a.field_id') . ' = ' . $db->quoteName('b.id') . ')')
		->join('INNER', $db->quoteName('#__user_usergroup_map', 'c')  . ' ON (' . $db->quoteName('a.item_id') . ' = ' . $db->quoteName('c.user_id') . ')')
		->where($db->quoteName('a.field_id') . ' = ' . $field_id)
		->where($db->quoteName('c.group_id') . ' = ' . $usergroup)
		->order($db->quoteName('a.value') . ' DESC');;	
	$db->setQuery($query);
	$field_values = $db->loadObjectList();
	return $field_values;
	}
	
	// grab users from selected usergroup, the fields and the table setup (ordering and arrow)..  
	static public function getFieldvalues($defaultorder, $field_id, $user_group_id)
	{
	// define columns..
	$columns = array('name','value');
	// grab the default order ..
	$column = isset($_GET['column']) && in_array($_GET['column'], $columns) ? $_GET['column'] : $defaultorder;
	// grab the desired order from the url..
	$sort_order = isset($_GET['order']) && strtolower($_GET['order']) == 'desc' ? 'DESC' : 'ASC';
	// grab sort order from url and pass it through in the return array..
	$up_or_down = str_replace(array('ASC','DESC'), array('up','down'), $sort_order); 
	$asc_or_desc = $sort_order == 'ASC' ? 'desc' : 'asc';
	// grab users..
	$db = Factory::getDbo();
	$query = $db
		->getQuery(true)
		->select($db->quoteName(['a.field_id', 'a.item_id', 'a.value', 'b.title', 'c.group_id', 'd.id', 'd.name']))
		->from($db->quoteName('#__fields_values', 'a'))
	    ->join('INNER', $db->quoteName('#__fields', 'b') . ' ON (' . $db->quoteName('a.field_id') . ' = ' . $db->quoteName('b.id') . ')')
		->join('INNER', $db->quoteName('#__user_usergroup_map', 'c')  . ' ON (' . $db->quoteName('a.item_id') . ' = ' . $db->quoteName('c.user_id') . ')')
	    ->join('INNER', $db->quoteName('#__users', 'd') . ' ON (' . $db->quoteName('d.id') . ' = ' . $db->quoteName('c.user_id') . ')')
		->where($db->quoteName('a.field_id') . ' = ' . $field_id)
		->where($db->quoteName('c.group_id') . ' = ' . $user_group_id)
		->order($db->quoteName('' . $column . '') . ' ' . $sort_order . '');
	$db->setQuery($query);
	// create arrays with fields and tablesetup..
	$field_values = $db->loadObjectList();
    $table_data_order = Array ("column" => "$column", "up_or_down" => "$up_or_down", "asc_or_desc" => "$asc_or_desc");
    // glue and return..
    $table_data = array_merge($table_data_order, $field_values);
	return (array) $table_data;
	}

	// get groupname..
 	static public function getGroupname($fieldsgroup)
	{
	$db = Factory::getDbo();
	$query = $db
		->getQuery(true)
		->select($db->quoteName(['title']))
		->from($db->quoteName('#__fields_groups'))
		->where($db->quoteName('id') . ' = ' . $fieldsgroup);	
	$db->setQuery($query);
	$groupname = $db->loadResult();
	return $groupname;
	}	

	// get fieldname
	static public function getFieldname($field_id)
	{
	$db = Factory::getDbo();
	$query = $db
		->getQuery(true)
		->select($db->quoteName(['title']))
		->from($db->quoteName('#__fields'))
		->where($db->quoteName('id') . ' = ' . $field_id);	
	$db->setQuery($query);
	$fieldname = $db->loadResult();
	return $fieldname;
	}	
	
    // get the fielddescription
	static public function getFielddescription($field_id)
	{
	$db = Factory::getDbo();
	$query = $db
		->getQuery(true)
		->select($db->quoteName(['description']))
		->from($db->quoteName('#__fields'))
		->where($db->quoteName('id') . ' = ' . $field_id);	
	$db->setQuery($query);
	$fielddescription = $db->loadResult();
	return $fielddescription;
	}
	
	static public function poweredBy($poweredby)
	{
		if ($poweredby == 1){
		echo "<span style='opacity:0.3; filter:alpha(opacity=30);float:right;'>powered: <a href='https://www.longlane.nl/amperevoltage'>ampère voltáge</a></small></span><br /><br />";
		} else {
		echo "<span style='opacity:0; filter:alpha(opacity=0);float:right;'>powered by: <a href='https://www.longlane.nl/amperevoltage'>ampère voltáge</a></small></span>";
		}
	}

}
