<?php
/**
* @version     6.0.0 
* @package     mod_lsfields_600
* @copyright   Copyright (C) 2026. All rights reserved. 
* @license     GNU General Public License version 2 or later; see LICENSE.txt 
* @author      Ampère Voltáge <> - https://www.longlane.nl 
*/

// no direct access..
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\Module\Lsfields\Site\Helper\LsfieldsHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\User\User;
?>

<?php if ($params->get('hcolor') || $params->get('hfontweight') || $params->get('hfontsize') ) :?>
	<?php // custom style headertag ?>
	<?php echo "\n<style>\n";?>
	<?php if ($params->get('hcolor')) : echo "h1 {color: " . $params->get('hcolor') ."; }\n"; endif ?>
	<?php if ($params->get('hweight')) : echo "h1 {font-weight: ". $params->get('hweight') ."; }\n"; endif ?>
	<?php if ($params->get('hsize')) : echo "h1 {font-size: ". $params->get('hsize') ."px; }\n"; endif ?>
	<?php echo "</style>\n";?>
<?php endif ?>

<?php
// custom style table 
if ($params->get('layouttable')) :?>
	<style>
	table.lsTable {border: var(--border); --border: 1px solid <?php echo $params->get('headbg')?>;}
	table.lsTable th {background: <?php echo $params->get('headbg')?>;}
	table.lsTable tr:hover th {background: <?php echo $params->get('headhover')?>;}
	table.lsTable tr:nth-child(even) {background: <?php echo $params->get('bgeven')?>;}
	table.lsTable tr:nth-child(odd) {background: <?php echo $params->get('bgodd')?>;}
	table.lsTable tr:hover {background: <?php echo $params->get('tablehover')?>;}
	table.lsTable tr:nth-child(even) .highlight {background: <?php echo $params->get('highlight')?>;}
	table.lsTable tr:nth-child(odd) .highlight {background: <?php echo $params->get('highlight')?>;}
	table.lsTable tr:hover .highlight{background: <?php echo $params->get('tablehover')?>;}
	table.lsTable th {color: <?php echo $params->get('headtxt')?>;}
	table.lsTable th a:link {color: <?php echo $params->get('headlink')?>;}
	table.lsTable th a:visited {color: <?php echo $params->get('headvlink')?>;}
	table.lsTable th a:hover {color: <?php echo $params->get('headhlink')?>;}
	table.lsTable th a:active {color: <?php echo $params->get('headalink')?>;}
	table.lsTable td {color: <?php echo $params->get('tabletxt')?>;}
	table.lsTable td a:link {color: <?php echo $params->get('tablelink')?>;}
	table.lsTable td a:visited {color: <?php echo $params->get('tablevlink')?>;}
	table.lsTable td a:hover {color: <?php echo $params->get('tablehlink')?>;}
	table.lsTable td a:active {color: <?php echo $params->get('tablealink')?>;}
	table.lsTable.view tr:hover .highlight{background: none;}?>
	table.lsTable.view tr:hover td {background: none;}?>
	</style>
<?php endif ?>

<?php // check if field_id is passed through url.. 
 if(isset($_GET['fid'])) {  $field_id = $_GET['fid']; }
 if (empty($field_id)) { $field_id = 0; }
?>

<?php // go on if a fieldsgroup is selected in the module or die ?>
	<?php if ($params->get('field_group_id')) : ?>	

	<?php // PAGETITLE ?>
	<?php if ($params->get('header') && $params->get('showfieldtitle') && $field_id !== 0) :?>
		<?php echo "<h1>" . $params->get('header') . " - "  . LsfieldsHelper::getFieldname($field_id).  "</h1>"; ?>
	<?php endif ?>	
	<?php if ($params->get('header') && $params->get('showfieldtitle') && $field_id == 0) :?>
		<?php echo "<h1>" . $params->get('header') . "</h1>"; ?>
	<?php endif ?>	
	<?php if ($params->get('header') && $params->get('showfieldtitle') == 0) :?>
		<?php echo "<h1>" . $params->get('header') . "</h1>"; ?>
	<?php endif ?>
	
	<?php // HEADER ?>	
	<?php if ($params->get('headertext')) :?>	
	 <div class="LsHeader">		
	  <?php echo $params->get('headertext'); ?>	
	 </div>	
	<?php endif ?>	 

	<div id="LsSelect">	  
	 <div id="LsSelectLeft">		
	  <form id="groupfields" method="get">		  
		<select name="select" id="lsselectgroup" class="form-select">
			<option <?php if (empty($field_id)){ echo("selected ");}?> value="0"><?php echo Text::_('LSF_SELECT_FIELD');?> </option>		  			 
			<?php foreach (LsfieldsHelper::getFields($params->get('field_group_id')) as $field=>$value){ ?>			  
			<option <?php if($value->id == $field_id) { echo("selected ");}?> value="<?php echo $value->id; ?>"> <?php echo $value->title; ?></option>
			<?php } // option.. ?>
		</select>	
	  </form>

	  <script>		
		  let urlid = "<?php echo Uri::current(); ?>?fid=";		  
		  document.getElementById('groupfields').addEventListener('change', (e) => {  e.preventDefault();		  
		  let lsselectgroup = document.getElementById('lsselectgroup').value;		  
		  console.log(urlid + lsselectgroup);		  
		  window.location.href = urlid + lsselectgroup;
		  });		
	  </script>

	 </div>	   
	 <div id="LsSelectMiddle"></div>	 	   
	 <div id="LsSelectRight"></div>	
	</div>	
	 
	<?php 	// build an userslist if field_id is selected from table	
	  if (!empty($field_id)) {		
	   $field_values = LsfieldsHelper::getFieldvalues($params->get('default_order'), 
	   $field_id, $params->get('user_group_id'));		
	   // split ordening info from array		
	   $table_data_order = array_slice($field_values, 0, 3);		
	   extract($table_data_order);		
	   // split data information from Array (after 3 values)		
	   $table_data = array_slice($field_values, 3);		
	   // highlight class from active column		
	   $add_class = ' class="highlight"';		
	 ?>		
	 
	 <?php if (LsfieldsHelper::getFielddescription($field_id)) :?>			
	  <div class="LsFielddesc">				
	 <?php echo LsfieldsHelper::getFielddescription($field_id); ?>
	  </div>		
	 <?php endif ?>		
	 
	 <table class="lsTable">
	  <thead>			
		<?php echo "<th scope='col'><a href='". Uri::current() ."?column=name&order=". $asc_or_desc ."&fid=". $field_id ."'>". Text::_('LSF_OPTION_USERNAME') ." <i class='fas fa-sort". ($column == 'name' ? '-' . $up_or_down : '') ."'></i></a></th>";?>				
		<?php echo "<th scope='col'><a href='". Uri::current() ."?column=value&order=". $asc_or_desc ."&fid=". $field_id ."'>". LsfieldsHelper::getFieldname($field_id) ." <i class='fas fa-sort". ($column == 'value' ? '-' . $up_or_down : '') ."'></i></a></th>";?>			 
	  </thead>		 

	  <tbody>		 		 		 
		<?php foreach($table_data as $field=>$value){ ?>			
		 <tr>			  	
		 <?php if ($params->get('uddeim')) :?>
		  <?php echo "<td data-label='". Text::_('LSF_OPTION_USERNAME') ."'".($column == 'name' ? $add_class : '') ."><a href='" . $params->get('uddeim') . "?task=new&recip=". $value->id ."'>". $value->name ."</a></td>";?>					
		 <?php endif; ?>				
		 <?php if (!$params->get('uddeim')) :?>					
		  <?php echo "<td data-label='". Text::_('LSF_OPTION_USERNAME') ."'".($column == 'name' ? $add_class : '') .">". $value->name ."</td>";?>
		 <?php endif; ?>					
		  <?php echo "<td data-label='". LsfieldsHelper::getFieldname($field_id) ."'".($column == 'value' ? $add_class : '') .">" . $value->value . "</td>";?>			  
		</tr>			
	   <?php } ?> 		 
	  </tbody>		
	 </table>	  
				
	<?php } ?>

	<?php // FOOTER ?>
	<?php if ($params->get('footertext')) :?>	
	 <div class="LsFooter">		
	  <?php echo $params->get('footertext'); ?>	
	 </div>
	<?php endif ?>
		
  <?php // die if a fieldsgroup is not selected in module ?>
  <?php else: ?>	
  <div class="LsError">		
   <?php echo Text::_('LSF_FIELDGROUP_NOT_SELECTED');?>  	
  </div>
<?php endif; ?>

<div class="LsPoweredby">  
 <?php echo LsfieldsHelper::poweredBy($params->get('powered_by'));?>
</div>