<?php
/**
 * @version     6.3.2
 * @package     mod_lsmoments_632
 * @copyright   Copyright (C) 2026. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ampère Voltáge <> - https://www.longlane.nl
 */
namespace Joomla\Module\Lsmoments\Site\Helper;

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Helper\ModuleHelper;

class LsmomentsHelper
{
	// processing the hideusers XML form field    
    static public function hideUsers($hideusers)  
   	{
	// validate	
	$hideusers = preg_replace('/\s+/', '', $hideusers); // removes spaces tabs etc.
	$pattern = "/^\d+(?:,\d+)*$/"; // only integer and comma's allowed..
	if (preg_match($pattern, $hideusers)) { 
		// always create an array
		$hide_uid1 = $hide_uid2 = $hide_uid3 = $hide_uid4 = $hide_uid5 = 0; // all 5 vars need a default value
		$l = explode(',', $hideusers,6);	  
		$length = sizeof($l);		
			for ($i = 0; $i < $length; $i++){		
			${"hide_uid".($i+1)} = $l[$i];} // the form fied values overwrites the default value 	  
		$hideusers = array($hide_uid1, $hide_uid2, $hide_uid3, $hide_uid4, $hide_uid5); // create array
	} else { $hideusers = array(0,0,0,0,0);}
	return $hideusers;
    }
	
	// Processing the birthday field XML form field    
    static public function checkField ($birthdayfield)  
	{
		// validate	
		$birthdayfield = preg_replace('/\s+/', '', $birthdayfield); // removes spaces tabs etc.
		$pattern = "/^\d+(?:,\d+)*$/"; // only integer and comma's allowed..
   	    if (!preg_match($pattern, $birthdayfield)){$birthdayfield = 0;}
	return $birthdayfield;
    }
	
	// check if the field is an datefield    
    static public function checkFieldvalue ($birthdayfield)  
	{	
	// echo $birthdayfield;exit;
		$db = Factory::getDbo();
		$query = $db
		  ->getQuery(true)
		  ->select($db->quoteName(['value']))
		  ->from($db->quoteName('#__fields_values'))
		  ->where($db->quoteName('field_id') . ' = ' . $birthdayfield)
		  ->setLimit(1);
		$db->setQuery($query);
		$fieldvalue = $db->loadResult();
			if (!empty($fieldvalue)) { 
				// echo $fieldvalue; exit;
				// regex to check is a date field	
				$pattern = "/^(\d{4})\-(0?[1-9]|1[012])\-(0?[1-9]|[12][0-9]|3[01]) ([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9])$/";
				if (preg_match($pattern, $fieldvalue)) {$fieldtype = 1; 
				} else {$fieldtype = 0;}
			} else {$fieldtype = 0;}		
	return $fieldtype;
    }
	
    // grab users from selected usergroup, the fields and the table setup (ordering and arrow)..    
    static public function getUsers($usergroup, $fieldid, $hideusers)
    {	
	$db = Factory::getDbo();
	$query = $db
		->getQuery(true)
		->select($db->quoteName(['a.field_id', 'a.item_id', 'a.value', 'b.title', 'c.group_id', 'd.id', 'd.name', 'd.email']))
		->from($db->quoteName('#__fields_values', 'a'))
	    ->join('INNER', $db->quoteName('#__fields', 'b') . ' ON (' . $db->quoteName('a.field_id') . ' = ' . $db->quoteName('b.id') . ')')
		->join('INNER', $db->quoteName('#__user_usergroup_map', 'c')  . ' ON (' . $db->quoteName('a.item_id') . ' = ' . $db->quoteName('c.user_id') . ')')
	    ->join('INNER', $db->quoteName('#__users', 'd') . ' ON (' . $db->quoteName('d.id') . ' = ' . $db->quoteName('c.user_id') . ')')
		->where($db->quoteName('a.field_id') . ' = ' . $fieldid)
		->where($db->quoteName('c.group_id') . ' = ' . $usergroup)
		->where ($db->quoteName('d.id').'!=' . $hideusers[0])
		->where ($db->quoteName('d.id').'!=' . $hideusers[1])
		->where ($db->quoteName('d.id').'!=' . $hideusers[2])
		->where ($db->quoteName('d.id').'!=' . $hideusers[3])
		->where ($db->quoteName('d.id').'!=' . $hideusers[4])	
		->order($db->quoteName('d.name'));
	$db->setQuery($query);
	$fields = $db->loadObjectList();
    return $fields;
	}

	static public function poweredBy($poweredby)
	{
		if ($poweredby == 1){
		echo "<span style='opacity:0.3; filter:alpha(opacity=30);float:right;'>by: <a href='https://www.longlane.nl/amperevoltage'>ampère voltáge</a></small></span>";
		}
	}
}
