<?php
/**
* @version     6.3.2
* @package     mod_lsmoments_632 
* @copyright   Copyright (C) 2026. All rights reserved. 
* @license     GNU General Public License version 2 or later; see LICENSE.txt 
* @author      Ampère Voltáge <> - https://www.longlane.nl 
*/

// no direct access..
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\Module\Lsmoments\Site\Helper\LsmomentsHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\User\User;
?>
<?php if(!isset($_GET['token'])) :?>

 <div class="LsModule">
 <?php // HEADER ?>	
 <?php if ($params->get('headertext')) :?>	
   <div class="LsModuleHeader">		
    <?php echo $params->get('headertext'); ?>	
   </div>	
  <?php endif ?>

 <div class="LsModuleContent">  
  <?php // go on if a birtdayfield is selected in the module ?>
  <?php 
  if ($params->get('birthdayfield')) :	
    // validate and check if the field has a date format 
    if (LsmomentsHelper::checkFieldvalue(LsmomentsHelper::checkField($params->get('birthdayfield')))) :	
      // create empty value if hideuserfield is empty
      $hideusers = $params->get('hideusers') == '' ? $hideusers = '0' : $hideusers = $params->get('hideusers');
      // grab users
      $users = LsmomentsHelper::getUsers ($params->get('usergroup'), LsmomentsHelper::checkField($params->get('birthdayfield')), LsmomentsHelper::hideUsers($hideusers));
      foreach ($users as $user=>$value){ 
	    date_default_timezone_set('UTC');
	    if (date('d-m', strtotime($value->value)) == date('d-m', strtotime($params->get('utc') . 'hour'))):?>
  	      <?php if ($params->get('uddeim')) { echo "<i class='".$params->get('icon')."'></i> <a href=' " . $params->get('uddeim') . "?task=new&recip=" . $value->id . "'>". $value->name ."</a><br />";}?>
	      <?php if (!$params->get('uddeim')) { echo "<i class='".$params->get('icon')."'></i> " . $value->name."<br>";}?>
	    <?php endif ?>
      <?php } // foreach ?>

    <?php // die if a birthdayfield is not a valid date field ?>
    <?php else: ?>	
      <div class="LsModuleError">		
       <i class="fa-solid fa-triangle-exclamation"></i> <?php echo Text::_('LSC_BIRTHDAYFIELD_NOT_VALID');?>  	
      </div>
    <?php endif; ?>
  <?php endif; ?>

  <?php 
  if ($params->get('moments')) :
    $moments = 'modules/mod_lsmoments/moments.csv';
    if (file_exists($moments)) {
      $moments = file_get_contents($moments);
      $moments = array_map("str_getcsv", preg_split('/\r*\n+|\r+/', $moments));
      foreach ($moments as $events=>$value){ 
	    if ($value[0] == date('d-m', strtotime($params->get('utc') . 'hour'))):?>
	 	 <?php echo "<i class='".$value[2]."'></i> ".$value[1]."<br />";?>
        <?php endif; ?>
		
		<?php // echo "<i class='".$value[2]."'></i> ".$value[1]."<br />";?>

		
	  <?php } // foreach ?>
	<?php } else { ?>
	  <div class="LsModuleError">		
        <i class="fa-solid fa-triangle-exclamation"></i> <?php echo Text::_('LSC_EVENTFILE_NOTFOUND');?>  	
      </div>
    <?php } ?>
   <?php endif; ?>
  </div>
  
  <?php // FOOTER ?>	
  <?php if ($params->get('footertext')) :?>	
   <div class="LsModuleFooter">		
    <?php echo $params->get('footertext'); ?>	
   </div>	
  <?php endif ?>
  
  <div class="LsPoweredby">  
   <?php echo LsmomentsHelper::poweredBy($params->get('powered_by'));?>
  </div>
 </div> 
<?php endif ?>