<?php
/** 
* @version     6.1.2 
* @package     mod_lsprofile_612 
* @copyright   Copyright (C) 2020 - 2026. All rights reserved. 
* @license     GNU General Public License version 2 or later; see LICENSE.txt 
* @author      Ampère Voltáge   <> - https://www.longlane.nl 
*/

namespace Joomla\Module\Lsprofile\Site\Helper;

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Helper\ModuleHelper;

class LsprofileHelper
{
	// processing the hideusers XML form field    
    static public function hideUsers ($hideusers)  
	{
		// validate	
		$hideusers = preg_replace('/\s+/', '', $hideusers); // removes spaces tabs etc.
		$pattern = "/^\d+(?:,\d+)*$/"; // only integer and comma's allowed..
		if (preg_match($pattern, $hideusers)) 
		{ 
			// always create an array
			$hide_uid1 = $hide_uid2 = $hide_uid3 = $hide_uid4 = $hide_uid5 = 0; // all 5 vars need a default value
			$l = explode(',', $hideusers,6);	  
			$length = sizeof($l);		
				for ($i = 0; $i < $length; $i++){		
				${"hide_uid".($i+1)} = $l[$i];} // the form fied values overwrites the default value 	  
			$hideusers = array($hide_uid1, $hide_uid2, $hide_uid3, $hide_uid4, $hide_uid5); // create array
		} else {
			$hideusers = array(0,0,0,0,0); 
		}
		return $hideusers;
    }
	
	// create an userlist with users in the same usergroup except the (max 5) hiding users
	static public function getUsers ($usergroup, $hideusers)  
	{
		$db = Factory::getDbo();
		$query = $db
		   ->getQuery(true)
		   ->select($db->quoteName(['a.id','a.name','a.username','a.email']))
		   ->from($db->quoteName('#__users', 'a'))
		   ->where($db->quoteName('a.block') . ' = ' . 0)
		   ->where($db->quoteName('b.group_id').'=' . $usergroup)
		   ->order($db->quoteName('a.name') . ' ASC ')
		   // skip the hide users array
		   ->where ($db->quoteName('a.id').'!=' . $hideusers[0])
		   ->where ($db->quoteName('a.id').'!=' . $hideusers[1])
		   ->where ($db->quoteName('a.id').'!=' . $hideusers[2])
		   ->where ($db->quoteName('a.id').'!=' . $hideusers[3])
		   ->where ($db->quoteName('a.id').'!=' . $hideusers[4])
		   ->join('INNER', $db->quoteName('#__user_usergroup_map', 'b') . ' ON ' . $db->quoteName('a.id') . ' = ' . $db->quoteName('b.user_id'));
		$db->setQuery($query);
		$users = $db->loadObjectList();
		return (array) $users; 
    }
	
	// create the first (profile) list 
	static public function getUser ($user_id)  
	{	
		$db = Factory::getDbo();
		$query = $db
		   ->getQuery(true)
			->select($db->quoteName(['id','name','username','email','registerDate','lastvisitDate']))
		   ->from($db->quoteName('#__users'))
		   ->where($db->quoteName('id') . ' = ' . $user_id);
		$db->setQuery($query);
		$user = $db->loadObjectList();
		return (array) $user; 
    }
   
    // get the fieldgroup
    static public function getFieldgroup ($field_group)  
	{	
		$db = Factory::getDbo();
		$query = $db
		   ->getQuery(true)
		   ->select($db->quoteName(['id','title']))
		   ->from($db->quoteName('#__fields_groups'))
		   ->where($db->quoteName('id') . ' = ' . $field_group);
		$db->setQuery($query);
		$field_group = $db->loadObjectList();
		return (array) $field_group; 
    }
	
	// Processing the (max 5) customfields XML form field    
    static public function customFields ($customfields)  
	{
		// validate	
		$customfields = preg_replace('/\s+/', '', $customfields); // removes spaces tabs etc.
		$pattern = "/^\d+(?:,\d+)*$/"; // only integer and comma's allowed..
		if (preg_match($pattern, $customfields)) 
		{ 
			// create array
			$cf_id1 = $cf_id2 = $cf_id3 = $cf_id4 = $cf_id5 = 0; // all 5 vars need a default value
			$l = explode(',', $customfields,6);	  
			$length = sizeof($l);		
				for ($i = 0; $i < $length; $i++){		
				${"cf_id".($i+1)} = $l[$i];} // the form fied value overwrite the default value 	  
			$customfields = $cf_id1.','.$cf_id2.','.$cf_id3.','.$cf_id4.','.$cf_id5; // create array
		} else {
			$customfields = '0,0,0,0,0'; 
		}
	return $customfields;
    }
		
	// check the customfield value    
    static public function checkFieldvalue ($field_id)  
	{	
		$db = Factory::getDbo();
		$query = $db
		  ->getQuery(true)
		  ->select($db->quoteName(['value']))
		  ->from($db->quoteName('#__fields_values'))
		  ->where($db->quoteName('field_id') . ' = ' . $field_id)
		  ->setLimit(1);
		  $db->setQuery($query);
		$fieldvalue = $db->loadResult();
		// regex to check is a date field	
		$pattern = "/^(\d{4})\-(0?[1-9]|1[012])\-(0?[1-9]|[12][0-9]|3[01]) ([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9])$/";
		if (preg_match($pattern, $fieldvalue)) 
		  {$fieldtype = "date"; } 
		else 
		  {$fieldtype = "text"; }
	return $fieldtype;
    }
	
	// get the custom field for specified specified user    
    static public function getCustomfield ($field_id, $user_id)  
	{	
		$db = Factory::getDbo();
		$query = $db
		->getQuery(true)
			->select($db->quoteName(['b.label','c.value']))
			->from($db->quoteName('#__users', 'a'))
			->where($db->quoteName('a.id') . ' = ' . $user_id)
			->join('INNER', $db->quoteName('#__fields', 'b') . ' ON ' . $db->quoteName('b.id') . ' = ' . $field_id)
			->join('INNER', $db->quoteName('#__fields_values', 'c') . ' ON ' . $db->quoteName('c.field_id') . ' = ' . $db->quoteName('b.id') . ' AND ' . $db->quoteName('c.item_id') .  '= ' . $db->quoteName('a.id'));
			$db->setQuery($query);
		$custom_field = $db->loadObjectList();
		return (array) $custom_field; 
    }
      
    // get the fields for specified fieldgroup and specified user    
    static public function getFields ($field_group, $user_id)  
	{	
		$db = Factory::getDbo();
		$query = $db
		   ->getQuery(true)
			->select($db->quoteName(['b.name','b.label','c.value']))
		   ->from($db->quoteName('#__users', 'a'))
		   ->where($db->quoteName('a.id') . ' = ' . $user_id)
		   ->order($db->quoteName('b.name') . ' ASC ')
		   ->join('INNER', $db->quoteName('#__fields', 'b') . ' ON ' . $db->quoteName('b.group_id') . ' = ' . $field_group)
		   ->join('INNER', $db->quoteName('#__fields_values', 'c') . ' ON ' . $db->quoteName('c.field_id') . ' = ' . $db->quoteName('b.id') . ' AND ' . $db->quoteName('c.item_id') .  '= ' . $db->quoteName('a.id'));
		$db->setQuery($query);
		$fields = $db->loadObjectList();
		return (array) $fields; 
    }
  
    // create token from user id
    static public function createToken ($user_id) 
    {	
	  $token = rand(1000, 9999) . ($user_id * 6);
	  return $token; 
	}

    // create user id from token
    static public function createUserid ($token) 
	{	
		$user_id = substr($token, -4) / 6;
		return $user_id; 
	}
	
   static public function poweredBy($poweredby)
	{
		if ($poweredby == 1){
		echo "<span style='opacity:0.3; filter:alpha(opacity=30);float:right;'>powered: <a href='https://www.longlane.nl/amperevoltage'>ampère voltáge</a></small></span><br /><br />";
		} else {
		echo "<span style='opacity:0; filter:alpha(opacity=0);float:right;'>powered by: <a href='https://www.longlane.nl/amperevoltage'>ampère voltáge</a></small></span>";
		}
	}
}
