<?php
/** 
* @version     6.1.2 
* @package     mod_lsprofile_612 
* @copyright   Copyright (C) 2020 - 2026. All rights reserved. 
* @license     GNU General Public License version 2 or later; see LICENSE.txt 
* @author      Ampère Voltáge   <> - https://www.longlane.nl 
*/

// no direct access..
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\Module\Lsprofile\Site\Helper\LsprofileHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\User\User;
?>

<?php if ($params->get('hcolor') || $params->get('hfontweight') || $params->get('hfontsize') ) :?>
	<?php // custom style headertag ?>
	<?php echo "\n<style>\n";?>
	<?php if ($params->get('hcolor')) : echo "h1 {color: " . $params->get('hcolor') ."; }\n"; endif ?>
	<?php if ($params->get('hweight')) : echo "h1 {font-weight: ". $params->get('hweight') ."; }\n"; endif ?>
	<?php if ($params->get('hsize')) : echo "h1 {font-size: ". $params->get('hsize') ."px; }\n"; endif ?>
	<?php echo "</style>\n";?>
<?php endif ?>

<?php
// custom style table 
if ($params->get('layouttable')) :?>
	<style>
	table.lsTable {border: var(--border); --border: 1px solid <?php echo $params->get('headbg')?>;}
	table.lsTable th {background: <?php echo $params->get('headbg')?>;}
	table.lsTable tr:hover th {background: <?php echo $params->get('headhover')?>;}
	table.lsTable tr:nth-child(even) {background: <?php echo $params->get('bgeven')?>;}
	table.lsTable tr:nth-child(odd) {background: <?php echo $params->get('bgodd')?>;}
	table.lsTable tr:hover {background: <?php echo $params->get('tablehover')?>;}
	table.lsTable tr:nth-child(even) .highlight {background: <?php echo $params->get('highlight')?>;}
	table.lsTable tr:nth-child(odd) .highlight {background: <?php echo $params->get('highlight')?>;}
	table.lsTable tr:hover .highlight{background: <?php echo $params->get('tablehover')?>;}
	table.lsTable th {color: <?php echo $params->get('headtxt')?>;}
	table.lsTable th a:link {color: <?php echo $params->get('headlink')?>;}
	table.lsTable th a:visited {color: <?php echo $params->get('headvlink')?>;}
	table.lsTable th a:hover {color: <?php echo $params->get('headhlink')?>;}
	table.lsTable th a:active {color: <?php echo $params->get('headalink')?>;}
	table.lsTable td {color: <?php echo $params->get('tabletxt')?>;}
	table.lsTable td a:link {color: <?php echo $params->get('tablelink')?>;}
	table.lsTable td a:visited {color: <?php echo $params->get('tablevlink')?>;}
	table.lsTable td a:hover {color: <?php echo $params->get('tablehlink')?>;}
	table.lsTable td a:active {color: <?php echo $params->get('tablealink')?>;}
	table.lsTable.view tr:hover .highlight{background: none;}?>
	table.lsTable.view tr:hover td {background: none;}?>
	</style>
<?php endif ?>

<?php
 // check if user_id (token) is passed through url.. 
 if(isset($_GET['token'])) { $token = $_GET['token']; }
 if (!empty($token)) { 
 // user-id is in the url..
  $user_id = LsprofileHelper::createUserid($token); // translate token to user-id
  $user = new \Joomla\CMS\User\User($user_id); // get the userfile
 } else { $user_id = 0; }	
 ?>
 
<?php // PAGETITLE ?>
<?php if ($params->get('header') && $params->get('showusertitle') && $user_id !== 0) :?>
 <?php echo "<h1>" . $params->get('header') . " - " . $user->name . "</h1>"; ?>
<?php endif ?>	
<?php if ($params->get('header') && $params->get('showusertitle') && $user_id == 0) :?>
 <?php echo "<h1>" . $params->get('header') . "</h1>"; ?>
<?php endif ?>	
<?php if ($params->get('header') && $params->get('showusertitle') == 0) :?>
 <?php echo "<h1>" . $params->get('header') . "</h1>"; ?>
<?php endif ?>

<?php // HEADER ?>	
<?php if ($params->get('headertext')) :?>	
<div class="LsHeader">		
<?php echo $params->get('headertext'); ?>	
</div>	
<?php endif ?>	 
 	  
 <div id="LsSelect">
  <div id="LsSelectLeft">
   <form id="userlist" method="get">
    <select name="select" id="lsselectuser" class="form-select">

	<?php // grab hideuser param. create empty string or check format ?>
	<?php $hideusers = $params->get('hideusers') == '' ? $hideusers = '0' : $hideusers = $params->get('hideusers');?>
	<?php $users = LsprofileHelper::getUsers($params->get('usergroup'), LsprofileHelper::hideUsers ($hideusers)); ?>
	  <option <?php if (empty($user_id)) { echo("selected ");}?> value="">  <?php echo Text::_('LSP_SELECT_USER');?> </option>		  
	  <?php foreach ($users as $user=>$value){ ?>
  	  <option <?php if($value->id == $user_id) { echo("selected ");}?> value="<?php echo LsprofileHelper::createToken($value->id); ?>"><?php echo $value->name; ?></option>
      <?php } ?>
    </select>
   </form>
   
   <script>
      let urlrid = "<?php echo Uri::current(); ?>?token=";
      document.getElementById('userlist').addEventListener('change', (e) => { e.preventDefault();
      let lsselectuser = document.getElementById('lsselectuser').value;
      console.log(urlrid + lsselectuser);
      window.location.href = urlrid + lsselectuser;
      });
    </script>
   
  </div>	   
  <div id="LsSelectMiddle"></div>	 	   
  <div id="LsSelectRight"></div>	
 </div>

 <?php if (!empty($user_id)) { ?>
 <?php
   $user = LsprofileHelper::getUser($user_id); 
   foreach($user as $user=>$value){ 
   ?>
    <table class="lsTable">
     <thead>
      <th><?php echo Text::_('LSP_USER_PROFILE');?> </th>  
      <th></th> 
     </thead>
	 <tr>
      <td width="150">
	  <?php echo Text::_('LSP_USER_NAME');?>
	  </td> 
      <td>
		  <?php if (!$params->get('uddeim')) :?>
		  <?php echo $value->name; ?> 	
		  <?php endif ?>
		  
		  <?php if ($params->get('uddeim')) :?>
		  <?php echo "<a href='" . $params->get('uddeim') . "?task=new&recip=". $value->id ."'>". $value->name ."</a>"; ?>
		  <?php endif ?>  
	  </td>
     </tr>
	  <tr>
      <td width="150"><?php echo Text::_('LSP_USER_NUMBER');?></td> 
      <td><?php echo $value->id;?></td>
     </tr>
	 <tr>
      <td width="150"><?php echo Text::_('LSP_USER_USERNAME');?></td> 
      <td><?php echo $value->username;?></td>
     </tr>
	 <tr>
      <td width="150"><?php echo Text::_('LSP_USER_EMAIL');?></td> 
      <td><a href="MAILTO:<?php echo $value->email;?>"><?php echo $value->email;?></a></td>
     </tr>	

	 <?php // processing possible custom field ?>
	 <?php 
	 // check parameter input customfields if empty value 0
	 $customfields = $params->get('customfields') == '' ? $customfields = 0 : $customfields = $params->get('customfields');
	 // create variabele for each custom field
	 $customfields = LsprofileHelper::customFields($customfields);
	 $l = explode(',', $customfields,6);
     $length = sizeof($l);
	 for ($i = 0; $i < $length; $i++){${"cf_id".($i+1)} = $l[$i];} 
	 ?>	
 
	 <?php // custom field 1 ?>
     <?php if ($cf_id1) :?>
	 <tr>
	  <?php $cf1 = LsprofileHelper::getCustomfield ($cf_id1, $user_id); 
	  foreach($cf1 as $customfield=>$field){ ?>   
	   <td width="150"><?php if ($params->get('customfieldslbl') ==  1) { echo Text::_('JMENU_CUSTOMFIELD1_LBL'); } else { echo $field->label; } ?></td> 
   	   <?php  if (LsprofileHelper::checkFieldvalue ($cf_id1) ==  'date') { echo "<td>" . date('d-m-Y', strtotime($field->value)) . "</td>"; }?>
	   <?php  if (LsprofileHelper::checkFieldvalue ($cf_id1) ==  'text') { echo "<td>" . $field->value . "</td>"; }?>
	  <?php } ?>		  
  	 </tr>		
	 <?php endif ?>

	 <?php // custom field 2 ?>
     <?php if ($cf_id2) :?>
	 <tr>
	  <?php $cf2 = LsprofileHelper::getCustomfield ($cf_id2, $user_id); 
	  foreach($cf2 as $customfield=>$field){ ?>   
	   <td width="150"><?php if ($params->get('customfieldslb2') ==  1) { echo Text::_('JMENU_CUSTOMFIELD2_LBL'); } else { echo $field->label; } ?></td> 
   	   <?php  if (LsprofileHelper::checkFieldvalue ($cf_id2) ==  'date') { echo "<td>" . date('d-m-Y', strtotime($field->value)) . "</td>"; }?>
	   <?php  if (LsprofileHelper::checkFieldvalue ($cf_id2) ==  'text') { echo "<td>" . $field->value . "</td>"; }?>
	  <?php } ?>		  
  	 </tr>		
	 <?php endif ?>
	 
	 <?php // custom field 3 ?>
     <?php if ($cf_id3) :?>
	 <tr>
	  <?php $cf3 = LsprofileHelper::getCustomfield ($cf_id3, $user_id); 
	    foreach($cf3 as $customfield=>$field){ ?>  
	   <td width="150"><?php if ($params->get('customfieldslbl') ==  1) { echo Text::_('JMENU_CUSTOMFIELD3_LBL'); } else { echo $field->label; } ?></td> 
   	   <?php  if (LsprofileHelper::checkFieldvalue ($cf_id3) ==  'date') { echo "<td>" . date('d-m-Y', strtotime($field->value)) . "</td>"; }?>
	   <?php  if (LsprofileHelper::checkFieldvalue ($cf_id3) ==  'text') { echo "<td>" . $field->value . "</td>"; }?>
	  <?php } ?>		  
  	 </tr>		
	 <?php endif ?>

	 <?php // custom field 4 ?>
     <?php if ($cf_id4) :?>
	 <tr>
	  <?php $cf4 = LsprofileHelper::getCustomfield ($cf_id4, $user_id); 
	  foreach($cf4 as $customfield=>$field){ ?>   
	   <td width="150"><?php if ($params->get('customfieldslbl') ==  1) { echo Text::_('JMENU_CUSTOMFIELD4_LBL'); } else { echo $field->label; } ?></td> 
   	   <?php  if (LsprofileHelper::checkFieldvalue ($cf_id4) ==  'date') { echo "<td>" . date('d-m-Y', strtotime($field->value)) . "</td>"; }?>
	   <?php  if (LsprofileHelper::checkFieldvalue ($cf_id4) ==  'text') { echo "<td>" . $field->value . "</td>"; }?>
	  <?php } ?>		  
  	 </tr>		
	 <?php endif ?>

	 <?php // custom field 5 ?>
     <?php if ($cf_id5) :?>
	 <tr>
	  <?php $cf5 = LsprofileHelper::getCustomfield ($cf_id5, $user_id); 
	  foreach($cf5 as $customfield=>$field){ ?>   
	   <td width="150"><?php if ($params->get('customfieldslbl') ==  1) { echo Text::_('JMENU_CUSTOMFIELD5_LBL'); } else { echo $field->label; } ?></td> 
   	   <?php  if (LsprofileHelper::checkFieldvalue ($cf_id5) ==  'date') { echo "<td>" . date('d-m-Y', strtotime($field->value)) . "</td>"; }?>
	   <?php  if (LsprofileHelper::checkFieldvalue ($cf_id5) ==  'text') { echo "<td>" . $field->value . "</td>"; }?>
	  <?php } ?>		  
  	 </tr>		
	 <?php endif ?>
	 <?php // end custom fields ?>
 
	<tr>
      <td width="150"><?php echo Text::_('LSP_USER_REGISTERDATE');?></td> 
      <td><?php echo date('d-m-Y', strtotime($value->registerDate));?></td>
     </tr>	
	 <?php if ($value->lastvisitDate) :?>
	 <tr>
      <td width="150"><?php echo Text::_('LSP_USER_LASTVISITDATE');?></td> 
      <td><?php echo date('d-m-Y', strtotime($value->lastvisitDate));?></td>
     </tr>	 
	 <?php endif ?> 
     <?php  } ?>
   </table>

<?php // Fieldgroup 1 ?>
  <?php  if (!empty($params->get('fg1'))) { ?>
   <br />
   <table class="lsTable">
    <thead>
    <?php
	// Get the title of the group
    $field_group = LsprofileHelper::getFieldgroup($params->get('fg1')); 
    foreach($field_group as $field_group=>$value){     
    ?>   
     <th><?php echo $value->title;?></th>  
     <th></th> 
     </thead>
    <?php  } ?>
 
	<?php
    // Get all fields from te group
	$fields = LsprofileHelper::getFields($params->get('fg1'), $user_id); 
    foreach($fields as $fields=>$value){  
    ?>
     <tr>
      <td width="150"><?php echo $value->label;?></td> 
      <td><?php echo $value->value;?></td>
     </tr>
    <?php  } ?>
   </table>
  <?php  } ?>
 
<?php // Fieldgroup 2 ?>  
  <?php  if (!empty($params->get('fg2'))) { ?>
   <br />
   <table class="lsTable">
    <thead>
    <?php
	// Get the title of the group
    $field_group = LsprofileHelper::getFieldgroup($params->get('fg2')); 
    foreach($field_group as $field_group=>$value){     
    ?>   
     <th><?php echo $value->title;?></th>  
     <th></th> 
     </thead>
    <?php  } ?>
 
	<?php
    // Get all fields from te group
	$fields = LsprofileHelper::getFields($params->get('fg2'), $user_id); 
    foreach($fields as $fields=>$value){  
    ?>
     <tr>
      <td width="150"><?php echo $value->label;?></td> 
      <td><?php echo $value->value;?></td>
     </tr>
    <?php  } ?>
   </table>
 <?php  } ?>

 <?php // Fieldgroup 3 ?>  
  <?php  if (!empty($params->get('fg3'))) { ?>
   <br />
   <table class="lsTable">
    <thead>
    <?php
	// Get the title of the group
    $field_group = LsprofileHelper::getFieldgroup($params->get('fg3')); 
    foreach($field_group as $field_group=>$value){     
    ?>   
     <th><?php echo $value->title;?></th>  
     <th></th> 
     </thead>
    <?php  } ?>
 
	<?php
    // Get all fields from te group
	$fields = LsprofileHelper::getFields($params->get('fg3'), $user_id); 
    foreach($fields as $fields=>$value){  
    ?>
     <tr>
      <td width="150"><?php echo $value->label;?></td> 
      <td><?php echo $value->value;?></td>
     </tr>
    <?php  } ?>
   </table>
 <?php  } ?>

 <?php // Fieldgroup 4 ?>  
  <?php  if (!empty($params->get('fg4'))) { ?>
   <table class="lsTable">
    <thead>
    <?php
	// Get the title of the group
    $field_group = LsprofileHelper::getFieldgroup($params->get('fg4')); 
    foreach($field_group as $field_group=>$value){     
    ?>   
     <th><?php echo $value->title;?></th>  
     <th></th> 
     </thead>
    <?php  } ?>
 
	<?php
    // Get all fields from te group
	$fields = LsprofileHelper::getFields($params->get('fg4'), $user_id); 
    foreach($fields as $fields=>$value){  
    ?>
     <tr>
      <td width="150"><?php echo $value->label;?></td> 
      <td><?php echo $value->value;?></td>
     </tr>
    <?php  } ?>
   </table>
 <?php  } ?>
 
 <?php // Fieldgroup 5 ?>  
  <?php  if (!empty($params->get('fg5'))) { ?>
   <br />  
   <table class="lsTable">
    <thead>
    <?php
	// Get the title of the group
    $field_group = LsprofileHelper::getFieldgroup($params->get('fg5')); 
    foreach($field_group as $field_group=>$value){     
    ?>   
     <th><?php echo $value->title;?></th>  
     <th></th> 
     </thead>
    <?php  } ?>
 
	<?php
    // Get all fields from te group
	$fields = LsprofileHelper::getFields($params->get('fg5'), $user_id); 
    foreach($fields as $fields=>$value){  
    ?>
     <tr>
      <td width="150"><?php echo $value->label;?></td> 
      <td><?php echo $value->value;?></td>
     </tr>
    <?php  } ?>
   </table>
 <?php  } ?>
 <?php  } ?>

<?php // FOOTER ?>
<?php if ($params->get('footertext')) :?>	
 <div class="LsFooter">		
  <?php echo $params->get('footertext'); ?>	
 </div>
<?php endif ?>

 <div class="LsPoweredby">  
  <?php echo LsprofileHelper::poweredBy($params->get('powered_by'));?>
  </div>