<?php
/**
 * @version     6.0.0
 * @package     mod_lsuserslist_6.0.0_j6x
 * @copyright   Copyright (C) 2026. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ampère Voltáge   <> - https://www.longlane.nl
 */
namespace Joomla\Module\Lsuserslist\Site\Helper;

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Language\Text;

class LsuserslistHelper
{
        // get the name of the usergroup..
        static public function getUsergroupname($usergroup)
        {
	    $db = Factory::getDbo();
	    $query = $db
          ->getQuery(true)
	      ->select($db->quoteName(['title']))
	      ->from($db->quoteName('#__usergroups'))
	      ->where($db->quoteName('id').'=' . $usergroup);
        $db->setQuery($query);
        $usergroup_name = $db->loadResult();
	    return $usergroup_name;
        }	   
 
	    // count the amount of users in the selected usergroup..
	    static public function  countUsers($usergroup, $hideusers)
	    {
  	    $db = Factory::getDbo();
		$query = $db
		  ->getQuery(true)
		  ->select($db->quoteName(['a.id']))
		  ->from($db->quoteName('#__users', 'a'))
		  ->where($db->quoteName('b.group_id').'=' . $usergroup)
		  ->where($db->quoteName('block').'='. 0)
		  ->where ($db->quoteName('a.id').'!=' . $hideusers[0])
		  ->where ($db->quoteName('a.id').'!=' . $hideusers[1])
		  ->where ($db->quoteName('a.id').'!=' . $hideusers[2])
		  ->where ($db->quoteName('a.id').'!=' . $hideusers[3])
		  ->where ($db->quoteName('a.id').'!=' . $hideusers[4])
		  ->join('INNER', $db->quoteName('#__user_usergroup_map', 'b') . ' ON ' . $db->quoteName('a.id') . ' = ' . $db->quoteName('b.user_id'));
		$db->setQuery($query);
		$totalusers = count($db->loadObjectList());	 
		return $totalusers;
	    }

		// processing the hideusers XML form field    
        static public function hideUsers ($hideusers)  
   	    {
	    // validate	
	    $hideusers = preg_replace('/\s+/', '', $hideusers); // removes spaces tabs etc.
	    $pattern = "/^\d+(?:,\d+)*$/"; // only integer and comma's allowed..
	    if (preg_match($pattern, $hideusers)) { 
			// always create an array
			$hide_uid1 = $hide_uid2 = $hide_uid3 = $hide_uid4 = $hide_uid5 = 0; // all 5 vars need a default value
			$l = explode(',', $hideusers,6);	  
			$length = sizeof($l);		
				for ($i = 0; $i < $length; $i++){		
				${"hide_uid".($i+1)} = $l[$i];} // the form fied values overwrites the default value 	  
			$hideusers = array($hide_uid1, $hide_uid2, $hide_uid3, $hide_uid4, $hide_uid5); // create array
		} else { $hideusers = array(0,0,0,0,0);}
	    return $hideusers;
        }
		
	    // grab users from selected usergroup, the fields and the table setup (ordering and arrow)..    
	    static public function  getUservalues($defaultorder, $usergroup, $hideusers)
	    {
	    // define columns..
	    $columns = array('id','username','name','email','registerDate','lastvisitDate');
	    // grab the default order ..
	    $column = isset($_GET['column']) && in_array($_GET['column'], $columns) ? $_GET['column'] : $defaultorder;
	    // grab the desired order from the url..
	    $sort_order = isset($_GET['order']) && strtolower($_GET['order']) == 'desc' ? 'DESC' : 'ASC';
	    // grab sort order from url and pass it through in the return array
	    $up_or_down = str_replace(array('ASC','DESC'), array('up','down'), $sort_order); 
	    $asc_or_desc = $sort_order == 'ASC' ? 'desc' : 'asc';
	    // grab users.
	    $db = Factory::getDbo();
	    $query = $db
			->getQuery(true)
			->select($db->quoteName(['a.id','a.username','a.name','a.email','a.registerDate','a.lastvisitDate','b.group_id']))
			->from($db->quoteName('#__users', 'a'))
			->where($db->quoteName('b.group_id').'='. $usergroup)
			->where($db->quoteName('block').'='. 0)
			->where ($db->quoteName('a.id').'!=' . $hideusers[0])
			->where ($db->quoteName('a.id').'!=' . $hideusers[1])
			->where ($db->quoteName('a.id').'!=' . $hideusers[2])
			->where ($db->quoteName('a.id').'!=' . $hideusers[3])
			->where ($db->quoteName('a.id').'!=' . $hideusers[4])
			->join('INNER', $db->quoteName('#__user_usergroup_map', 'b') . ' ON ' . $db->quoteName('a.id') . ' = ' . $db->quoteName('b.user_id'))
			->order($db->quoteName('' . $column . '') . ' ' . $sort_order . '');
 	    $db->setQuery($query);
	    // create arrays with users and table setup..
	    $user_values = $db->loadObjectList();
	    $table_data_order = Array ("column" => "$column", "up_or_down" => "$up_or_down", "asc_or_desc" => "$asc_or_desc");
	    // glue and return..
	    $table_data = array_merge($table_data_order, $user_values);
	    return (array) $table_data;
	    }

		// create token from user id
		static public function createToken ($user_id) 
		{	
		  $token = rand(1000, 9999) . ($user_id * 6);
		  return $token; 
		}

		// create user id from token
		static public function createUserid ($token) 
		{	
			$user_id = substr($token, -4) / 6;
			return $user_id; 
		}
		  
	static public function poweredBy($poweredby)
	{
		if ($poweredby == 1){
		echo "<span style='opacity:0.3; filter:alpha(opacity=30);float:right;'>powered: <a href='https://www.longlane.nl/amperevoltage'>ampère voltáge</a></small></span><br /><br />";
		} else {
		echo "<span style='opacity:0; filter:alpha(opacity=0);float:right;'>powered by: <a href='https://www.longlane.nl/amperevoltage'>ampère voltáge</a></small></span>";
		}
	}

}