<?php
/**
 * @version     6.0.0
 * @package     mod_lsuserslist_600
 * @copyright   Copyright (C) 2026. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ampère Voltáge   <> - https://www.longlane.nl
 */

//No direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Helper\ModuleHelper;
use Joomla\Module\Lsuserslist\Site\Helper\LsuserslistHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\User\User;
?>

<?php // ckeck param ?>
<?php if (!$params->get('usergroup')) :
echo "No usergroup selected";die;?>
<?php endif ?>

<?php
// custom style table 
if ($params->get('layouttable')) :?>
	<style>
	table.lsTable {border: var(--border); --border: 1px solid <?php echo $params->get('headbg')?>;}
	table.lsTable th {background: <?php echo $params->get('headbg')?>;}
	table.lsTable tr:hover th {background: <?php echo $params->get('headhover')?>;}
	table.lsTable tr:nth-child(even) {background: <?php echo $params->get('bgeven')?>;}
	table.lsTable tr:nth-child(odd) {background: <?php echo $params->get('bgodd')?>;}
	table.lsTable tr:hover {background: <?php echo $params->get('tablehover')?>;}
	table.lsTable tr:nth-child(even) .highlight {background: <?php echo $params->get('highlight')?>;}
	table.lsTable tr:nth-child(odd) .highlight {background: <?php echo $params->get('highlight')?>;}
	table.lsTable tr:hover .highlight{background: <?php echo $params->get('tablehover')?>;}
	table.lsTable th {color: <?php echo $params->get('headtxt')?>;}
	table.lsTable th a:link {color: <?php echo $params->get('headlink')?>;}
	table.lsTable th a:visited {color: <?php echo $params->get('headvlink')?>;}
	table.lsTable th a:hover {color: <?php echo $params->get('headhlink')?>;}
	table.lsTable th a:active {color: <?php echo $params->get('headalink')?>;}
	table.lsTable td {color: <?php echo $params->get('tabletxt')?>;}
	table.lsTable td a:link {color: <?php echo $params->get('tablelink')?>;}
	table.lsTable td a:visited {color: <?php echo $params->get('tablevlink')?>;}
	table.lsTable td a:hover {color: <?php echo $params->get('tablehlink')?>;}
	table.lsTable td a:active {color: <?php echo $params->get('tablealink')?>;}
	table.lsTable.view tr:hover .highlight{background: none;}?>
	table.lsTable.view tr:hover td {background: none;}?>
	</style>
<?php endif ?>

<?php if ($params->get('hcolor') || $params->get('hfontweight') || $params->get('hfontsize') ) :?>
	<?php // custom style headertag ?>
	<?php echo "\n<style>\n";?>
	<?php if ($params->get('hcolor')) : echo "h1 {color: " . $params->get('hcolor') ."; }\n"; endif ?>
	<?php if ($params->get('hweight')) : echo "h1 {font-weight: ". $params->get('hweight') ."; }\n"; endif ?>
	<?php if ($params->get('hsize')) : echo "h1 {font-size: ". $params->get('hsize') ."px; }\n"; endif ?>
	<?php echo "</style>\n";?>
<?php endif ?>

<?php // build an userlist?>
<?php // grab hideuser param. create empty string or check format ?>
<?php $hideusers = $params->get('hideusers') == '' ? $hideusers = '0' : $hideusers = $params->get('hideusers');?>

<?php 
$user_values = LsuserslistHelper::getUservalues($params->get('defaultorder'), $params->get('usergroup'), LsuserslistHelper::hideUsers($hideusers));
// Split sorting information from array (first 3 values)
$table_data_order = array_slice($user_values, 0, 3);
extract($table_data_order);
// split data information from Array (after 3 values)	
$table_data = array_slice($user_values, 3);
// highlight the active column
$add_class = ' class="highlight"';
?>

<?php // PAGETITLE ?>
<?php if ($params->get('header') && $params->get('showlisttitle') == 1) :?>
<?php echo "<h1>" . $params->get('header') . " - "  . LsuserslistHelper::getUsergroupname($params->get('usergroup')) .  " (" . LsuserslistHelper::countUsers($params->get('usergroup'), LsuserslistHelper::hideUsers($hideusers)) . ")</h1>"; ?>
<?php endif ?>	
<?php if ($params->get('header') && $params->get('showlisttitle') == 0) :?>
<?php echo "<h1>" . $params->get('header') . "</h1>"; ?>
<?php endif ?>
<?php if (!$params->get('header') && $params->get('showlisttitle') == 1) :?>
<?php echo "<h1>" . LsuserslistHelper::getUsergroupname ($params->get('usergroup')) .  " (" . LsuserslistHelper::countUsers($params->get('usergroup'), LsuserslistHelper::hideUsers($hideusers)) . ")</h1>"; ?>

<?php endif ?>

<?php // HEADER ?>	
<?php if ($params->get('headertext')) :?>	
<div class="LsHeader">		
<?php echo $params->get('headertext'); ?>	
</div>	
<?php endif ?>

<?php // CONTENT ?>
<div class="LsContent">
<table class="lsTable">
  <thead>
	<tr>
		<?php if ($params->get('showuserid') > 0) { echo "<th scope='col'><a href='". Uri::current() ."?column=id&order=". $asc_or_desc ."'>". Text::_('LSU_USER_ID') ." <i class='fas fa-sort". ($column == 'id' ? '-' . $up_or_down : '') ."'></i></a></th>";}?>	
		<?php if ($params->get('showusername') > 0) { echo "<th scope='col'><a href='". Uri::current() ."?column=username&order=". $asc_or_desc ."'>". Text::_('LSU_USER_NAME') ." <i class='fas fa-sort". ($column == 'username' ? '-' . $up_or_down : '') ."'></i></a></th>";}?>	
		<?php if ($params->get('showuseremail') > 0) { echo "<th scope='col'><a href='". Uri::current() ."?column=email&order=". $asc_or_desc ."'>". Text::_('LSU_USER_EMAIL') ." <i class='fas fa-sort". ($column == 'email' ? '-' . $up_or_down : '') ."'></i></a></th>";}?>	
		<?php if ($params->get('showregisterdate') == 1) { echo "<th scope='col'><a href='". Uri::current() ."?column=registerDate&order=". $asc_or_desc ."'>". Text::_('LSU_USER_DATE_REGISTER') ." <i class='fas fa-sort". ($column == 'registerDate' ? '-' . $up_or_down : '') ."'></i></a></th>";}?>	
		<?php if ($params->get('showlastvisitdate') == 1) { echo "<th scope='col'><a href='". Uri::current() ."?column=lastvisitDate&order=". $asc_or_desc ."'>". Text::_('LSU_USER_DATE_LASTVISIT') ." <i class='fas fa-sort". ($column == 'lastvisitDate' ? '-' . $up_or_down : '') ."'></i></a></th>";}?>	
	</tr>
  </thead>  

  <tbody>
   <?php foreach($table_data as $user=>$value){ ?>
	 <tr>
	 	<?php // building first column ?> 
		<?php if ($params->get('showuserid') > 0) :?>
		    <?php if ($params->get('showuserid') == 1) { echo "<td data-label='". Text::_('LSU_USER_ID') ."'".($column == 'id' ? $add_class : '') .">". $value->id ."</td>";}?>
		    <?php if ($params->get('showuserid') == 2) { echo "<td data-label='". Text::_('LSU_USER_ID') ."'".($column == 'id' ? $add_class : '') ."><a href='MAILTO:". $value->email ."'>". $value->id ."</a></td>";}?>
			<?php if ($params->get('showuserid') == 3) 
				{ 
				if ($params->get('lsprofile')) { echo "<td data-label='". Text::_('LSU_USER_ID') ."'".($column == 'id' ? $add_class : '') ."><a href=' " . $params->get('lsprofile') . "?token=" .  LsuserslistHelper::createToken($value->id)  ."'>". $value->id ."</a></td>";}
				if (!$params->get('lsprofile')) { echo "<td align='center' data-label='". Text::_('LSU_USER_ID') ."'".($column == 'id' ? $add_class : '') ."><i class='fa-solid fa-triangle-exclamation' title=Text::_('LSU_TOOLTIP_MISSING_LSPROFILE')></i></td>"; }
				} ?> 

			<?php if ($params->get('showuserid') == 4) 
				{ 
				if ($params->get('uddeim')) { echo "<td data-label='". Text::_('LSU_USER_ID') ."'".($column == 'id' ? $add_class : '') ."><a href=' " . $params->get('uddeim') . "?task=new&recip=" . $value->id . "'>". $value->id ."</a></td>";}
				if (!$params->get('uddeim')) { echo "<td align='center' data-label='". Text::_('LSU_USER_ID') ."'".($column == 'id' ? $add_class : '') ."><i class='fa-solid fa-triangle-exclamation' title=Text::_('LSU_TOOLTIP_MISSING_UDDEIM')></i></td>"; }
				} ?> 
		<?php endif ?>


	 	<?php // building second column ?> 
		<?php if ($params->get('showusername') > 0) :?>
		    <?php if ($params->get('showusername') == 1) { echo "<td data-label='". Text::_('LSU_USER_NAME') ."'".($column == 'id' ? $add_class : '') .">". $value->name ."</td>";}?>
		    <?php if ($params->get('showusername') == 2) { echo "<td data-label='". Text::_('LSU_USER_NAME') ."'".($column == 'id' ? $add_class : '') ."><a href='MAILTO:". $value->email ."'>". $value->name ."</a></td>";}?>
			<?php if ($params->get('showusername') == 3) 
				{ 
				if ($params->get('lsprofile')) { echo "<td data-label='". Text::_('LSU_USER_NAME') ."'".($column == 'id' ? $add_class : '') ."><a href=' " . $params->get('lsprofile') . "?token=" . LsuserslistHelper::createToken($value->id) ."'>". $value->name ."</a></td>";}
				if (!$params->get('lsprofile')) { echo "<td align='center' data-label='". Text::_('LSU_USER_NAME') ."'".($column == 'id' ? $add_class : '') ."><i class='fa-solid fa-triangle-exclamation' title=Text::_('LSU_TOOLTIP_MISSING_LSPROFILE')></i></td>"; }
				} ?> 
			<?php if ($params->get('showusername') == 4) 
				{ 
				if ($params->get('uddeim')) { echo "<td data-label='". Text::_('LSU_USER_ID') ."'".($column == 'username' ? $add_class : '') ."><a href=' " . $params->get('uddeim') . "?task=new&recip=" . $value->id . "'>". $value->name ."</a></td>";}
				if (!$params->get('uddeim')) { echo "<td align='center' data-label='". Text::_('LSU_USER_ID') ."'".($column == 'username' ? $add_class : '') ."><i class='fa-solid fa-triangle-exclamation' title=Text::_('LSU_TOOLTIP_MISSING_UDDEIM')></i></td>"; }
				} ?> 		
		<?php endif ?>

	 	<?php // building third column ?> 
		<?php if ($params->get('showuseremail') > 0) :?>
		    <?php if ($params->get('showuseremail') == 1) { echo "<td data-label='". Text::_('LSU_USER_NAME') ."'".($column == 'email' ? $add_class : '') .">". $value->email ."</td>";}?>
		    <?php if ($params->get('showuseremail') == 2) { echo "<td data-label='". Text::_('LSU_USER_NAME') ."'".($column == 'email' ? $add_class : '') ."><a href='MAILTO:". $value->email ."'>". $value->email ."</a></td>";}?>
   	    <?php endif ?>

		<?php // building fourth column ?> 
		<?php if ($params->get('showregisterdate') == 1) { echo "<td data-label='". Text::_('LSU_USER_DATE_REGISTER') ."'".($column == 'registerDate' ? $add_class : '') .">". date('d-m-Y', strtotime($value->registerDate)). "</td>";}?>
		<?php // building fifth column ?> 
		<?php if ($params->get('showlastvisitdate') == 1) { echo "<td data-label='". Text::_('LSU_USER_DATE_LASTVISIT') ."'".($column == 'lastvisitDate' ? $add_class : '') .">"; if ($value->lastvisitDate) : echo date('d-m-Y', strtotime($value->lastvisitDate)); endif; echo "</td>";} ?>
	</tr>
	<?php } ?> 
  </tbody>
 </table>
 </div>
 
<?php // FOOTER ?>
<?php if ($params->get('footertext')) :?>	
 <div class="LsFooter">		
  <?php echo $params->get('footertext'); ?>	
 </div>
<?php endif ?>

<div class="LsPoweredby">  
  <?php echo LsuserslistHelper::poweredBy($params->get('powered_by'));?>
</div>
<hr /> 
