<?php
/**
 * @version     4.0.2
 * @package     mod_lsvisits_402
 * @copyright   Copyright (C) 2023. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Ampère Voltáge <> - https://www.longlane.nl
 */

namespace Joomla\Module\Lsvisits\Site\Helper;

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Helper\ModuleHelper;

class LsvisitsHelper
{
	// processing the hideusers XML form field    
    static public function hideUsers($hideusers)  
   	{
	// validate	
	$hideusers = preg_replace('/\s+/', '', $hideusers); // removes spaces tabs etc.
	$pattern = "/^\d+(?:,\d+)*$/"; // only integer and comma's allowed..
	if (preg_match($pattern, $hideusers)) { 
		// always create an array
		$hide_uid1 = $hide_uid2 = $hide_uid3 = $hide_uid4 = $hide_uid5 = 0; // all 5 vars need a default value
		$l = explode(',', $hideusers,6);	  
		$length = sizeof($l);		
			for ($i = 0; $i < $length; $i++){		
			${"hide_uid".($i+1)} = $l[$i];} // the form fied values overwrites the default value 	  
		$hideusers = array($hide_uid1, $hide_uid2, $hide_uid3, $hide_uid4, $hide_uid5); // create array
	} else { $hideusers = array(0,0,0,0,0);}
		// print_r($hideusers);exit;
	return $hideusers;
    }
	
    // grab users from selected usergroup, the fields and the table setup (ordering and arrow)..    
    static public function getVisitors($usergroup, $hideusers, $maxvisitors)
    {
    // exit;
    $db = Factory::getDbo();
	$query = $db
		->getQuery(true)
		->select('a.id, a.name, a.username, a.email, a.lastvisitDate')
		->from($db->quoteName('#__users', 'a'))
		->join('INNER', $db->quoteName('#__user_usergroup_map', 'b')  . ' ON (' . $db->quoteName('a.id') . ' = ' . $db->quoteName('b.user_id') . ')')
		->where($db->quoteName('b.group_id') . ' = ' . $usergroup)
		->where ($db->quoteName('a.id').'!=' . $hideusers[0])
		->where ($db->quoteName('a.id').'!=' . $hideusers[1])
		->where ($db->quoteName('a.id').'!=' . $hideusers[2])
		->where ($db->quoteName('a.id').'!=' . $hideusers[3])
		->where ($db->quoteName('a.id').'!=' . $hideusers[4])		 
		->where($db->quoteName('block').'='. 0)
		->where ($db->quoteName('lastvisitDate').'> 1900-01-01')
	   	->setLimit($maxvisitors)
		->order($db->quoteName('lastvisitDate') .'DESC');
	$db->setQuery($query);
	$visitors =  $db->loadObjectList();
    return $visitors;
    }

	static public function poweredBy($poweredby)
	{
		if ($poweredby == 1){
		echo "<span style='opacity:0.3; filter:alpha(opacity=30);float:right;'>by: <a href='https://www.longlane.nl/amperevoltage'>ampère voltáge</a></small></span>";
		} 
	}
}
