<?php
// @package    ls-loginscript
// @copyright  Copyright (c) 2007-2019 <$. All rights reserved.
// @license    GNU General Public License
// @version    1.0
// @support    Longlane Scripting https://www.longlane.nl
// @author     Ampère Voltáge
?>

<?php
if (isset($_POST['submit'])) {
    require 'database.php';
    $username = $_POST['username'];
    $email = $_POST['email'];
    $password = $_POST['password'];
    $confirmPass = $_POST['confirmPassword'];
    if (empty($username) || empty($password) || empty($confirmPass) || empty($email)) {
        header("Location: ../register.php?status=alle velden moeten worden ingevuld&username=".$username."&email=".$email);
        exit();
    } elseif (!preg_match("/^[a-zA-Z0-9]*/", $username)) {
        header("Location: ../register.php?status=kies een andere gebruikersnaam&email=".$email);
        exit();
	} elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        header("Location: ../register.php?status=het e-mail adres is niet geldig&username=".$username);
        exit();	
        } elseif($password !== $confirmPass) {
        header("Location: ../register.php?status=wachtwoorden zijn niet gelijk&username=".$username ."&email=".$email);
        exit();
    }
    else {
        $sql = "SELECT username FROM users WHERE username = ?";
        $stmt = mysqli_stmt_init($conn);
        if (!mysqli_stmt_prepare($stmt, $sql)) {
            header("Location: ../register.php?status=database problemen. voer de setup uit...");
            exit();
        } else {
            mysqli_stmt_bind_param($stmt, "s", $username);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_store_result($stmt);
            $rowCount = mysqli_stmt_num_rows($stmt);

            if ($rowCount > 0) {
                header("Location: ../register.php?status=gebruikersnaam bestaat al&email=".$email);
                exit();
            } else {
                $sql = "INSERT INTO users (username, password, email) VALUES (?, ?, ?)";
                $stmt = mysqli_stmt_init($conn);
                if (!mysqli_stmt_prepare($stmt, $sql)) {
                    header("Location: ../register.php?status=database problemen. voer de setup uit...");
                    exit();
                } else {
                    $hashedPass = password_hash($password, PASSWORD_DEFAULT);
                    mysqli_stmt_bind_param($stmt, "sss", $username, $hashedPass, $email);
                    mysqli_stmt_execute($stmt);
                    header("Location: ../login.php?status=je bent geregistreerd en kan nu inloggen");
                    exit();
                }
            }
        }
    }
    mysqli_stmt_close($stmt);
    mysqli_close($conn);
}
?>
